/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.mobholder;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.common.capabilities.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.capabilities.SupplementariesCapabilities;
import net.mehvahdjukaar.supplementaries.common.mobholder.DefaultCatchableMobCap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class MobContainer {
    @Nullable
    private World world;
    private BlockPos pos;
    @Nullable
    private MobData data;
    @Nullable
    private ICatchableMob mobDisplayCapInstance;
    private boolean needsInitialization = false;

    public MobContainer(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    public void setWorldAndPos(World world, BlockPos pos) {
        this.pos = pos;
        this.world = world;
    }

    public void updateLightLevel() {
        if (this.world != null && !this.world.field_72995_K) {
            int light = this.hasDisplayMob() ? this.mobDisplayCapInstance.getLightLevel() : CapturedMobsHelper.getTypeFromBucket(this.data.filledBucket.func_77973_b()).getLightLevel();
            BlockState state = this.world.func_180495_p(this.pos);
            if ((Integer)state.func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15) != light) {
                this.world.func_180501_a(this.pos, (BlockState)state.func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    public static <E extends Entity> ICatchableMob getCap(E entity2) {
        ICatchableMob cap;
        if (entity2 == null) {
            return null;
        }
        if (entity2 instanceof ICatchableMob) {
            cap = (ICatchableMob)entity2;
        } else {
            LazyOptional opt = entity2.getCapability(SupplementariesCapabilities.CATCHABLE_MOB_CAP);
            cap = (ICatchableMob)opt.orElseGet(() -> DefaultCatchableMobCap.getDefaultCap(entity2));
        }
        return cap;
    }

    public CompoundNBT save(CompoundNBT tag) {
        if (!this.isEmpty()) {
            this.data.saveToTag(tag);
        }
        return tag;
    }

    public void load(CompoundNBT tag) {
        MobData data = MobData.loadFromTag(tag);
        this.setData(data);
    }

    private void setData(@Nullable MobData data) {
        this.data = data;
        this.needsInitialization = true;
    }

    private void initializeEntity() {
        this.needsInitialization = false;
        if (this.data != null && this.world != null && this.pos != null) {
            Entity entity2 = MobContainer.createStaticMob(this.data, this.world, this.pos);
            this.mobDisplayCapInstance = MobContainer.getCap(entity2);
            this.updateLightLevel();
        }
    }

    @Nullable
    public static Entity createStaticMob(MobData data, @Nonnull World world, BlockPos pos) {
        Entity entity2 = null;
        if (data != null && !data.isAquarium && data.mobTag != null) {
            entity2 = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity2 == null) {
                return null;
            }
            double px = (double)pos.func_177958_n() + entity2.func_226277_ct_();
            double py = (double)pos.func_177956_o() + entity2.func_226278_cu_();
            double pz = (double)pos.func_177952_p() + entity2.func_226281_cx_();
            entity2.func_70107_b(px, py, pz);
            entity2.field_70142_S = px;
            entity2.field_70137_T = py;
            entity2.field_70136_U = pz;
            entity2.field_70169_q = px;
            entity2.field_70167_r = py;
            entity2.field_70166_s = pz;
        }
        return entity2;
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundNBT com, @Nullable UUID id, World world) {
        if (com != null && com.func_74764_b("id")) {
            Entity entity2;
            String name;
            switch (name = com.func_74781_a("id").func_150285_a_()) {
                case "minecraft:bee": {
                    entity2 = new BeeEntity(EntityType.field_226289_e_, world);
                    break;
                }
                case "minecraft:iron_golem": {
                    entity2 = new IronGolemEntity(EntityType.field_200757_aw, world);
                    break;
                }
                case "minecraft:enderman": {
                    entity2 = new EndermanEntity(EntityType.field_200803_q, world);
                    break;
                }
                case "minecraft:wolf": {
                    entity2 = new WolfEntity(EntityType.field_200724_aC, world);
                    break;
                }
                default: {
                    entity2 = EntityType.func_220335_a((CompoundNBT)com, (World)world, o -> o);
                }
            }
            if (id != null && entity2 != null) {
                entity2.func_184221_a(id);
            }
            return entity2;
        }
        return null;
    }

    public boolean interactWithBucket(ItemStack stack, World world, BlockPos pos, @Nullable PlayerEntity player, Hand hand) {
        Item item2 = stack.func_77973_b();
        ItemStack returnStack = ItemStack.field_190927_a;
        if (this.isEmpty()) {
            if (CapturedMobsHelper.isFishBucket(item2)) {
                world.func_184133_a(null, pos, SoundEvents.field_203819_X, SoundCategory.BLOCKS, 1.0f, 1.0f);
                returnStack = new ItemStack((IItemProvider)Items.field_151133_ar);
                MobData data = new MobData(stack.func_77946_l());
                this.setData(data);
            }
        } else if (!this.data.filledBucket.func_190926_b() && item2 == Items.field_151133_ar) {
            world.func_184133_a(null, pos, SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 1.0f, 1.0f);
            returnStack = this.data.filledBucket.func_77946_l();
            this.setData(null);
        }
        if (!returnStack.func_190926_b()) {
            if (player != null) {
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item2));
                if (!player.func_184812_l_()) {
                    Utils.swapItem((PlayerEntity)player, (Hand)hand, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public boolean hasDisplayMob() {
        return this.mobDisplayCapInstance != null;
    }

    public void tick() {
        if (this.needsInitialization) {
            this.initializeEntity();
        }
        if (this.hasDisplayMob()) {
            ++this.mobDisplayCapInstance.getEntity().field_70173_aa;
            this.mobDisplayCapInstance.tickInsideContainer(this.world, this.pos, this.data.scale, this.data.mobTag);
        }
    }

    public ActionResultType onInteract(World world, BlockPos pos, PlayerEntity player, Hand hand) {
        if (this.hasDisplayMob()) {
            return this.mobDisplayCapInstance.onPlayerInteract(world, pos, player, hand, this.data.mobTag);
        }
        return ActionResultType.PASS;
    }

    public MobData getData() {
        return this.data;
    }

    @Nullable
    public Entity getDisplayedMob() {
        if (this.hasDisplayMob()) {
            return this.mobDisplayCapInstance.getEntity();
        }
        return null;
    }

    public boolean shouldHaveWater() {
        return this.data.isAquarium || this.hasDisplayMob() && this.mobDisplayCapInstance.shouldHaveWater();
    }

    @Nullable
    public static CompoundNBT createMobHolderItemTag(@Nonnull Entity mob, float blockW, float blockH, ItemStack bucketStack, boolean isAquarium) {
        MobData data;
        String name = mob.func_200200_C_().getString();
        if (isAquarium && CapturedMobsHelper.getType(mob).isFish()) {
            data = new MobData(name, bucketStack);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(mob, blockW, blockH);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            double px = 0.5;
            double py = (double)yOffset + 1.0E-4;
            double pz = 0.5;
            mob.func_70107_b(px, py, pz);
            mob.field_70142_S = px;
            mob.field_70137_T = py;
            mob.field_70136_U = pz;
            CompoundNBT mobTag = MobContainer.prepareMobTagForContainer(mob);
            if (mobTag == null) {
                return null;
            }
            UUID id = mob.func_110124_au();
            data = new MobData(name, mobTag, scale, id, bucketStack);
        }
        CompoundNBT cmp = new CompoundNBT();
        data.saveToTag(cmp);
        return cmp;
    }

    @Nullable
    private static CompoundNBT prepareMobTagForContainer(Entity mob) {
        if (mob.func_184218_aH()) {
            mob.func_184187_bx().func_184226_ay();
        }
        if (mob instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)mob;
            le.field_70758_at = 0.0f;
            le.field_70759_as = 0.0f;
            le.field_70721_aZ = 0.0f;
            le.field_184618_aE = 0.0f;
            le.field_184619_aG = 0.0f;
            le.field_70738_aO = 0;
            le.field_70737_aN = 0;
            le.field_70733_aJ = 0.0f;
        }
        mob.field_70177_z = 0.0f;
        mob.field_70126_B = 0.0f;
        mob.field_70127_C = 0.0f;
        mob.field_70125_A = 0.0f;
        mob.func_70066_B();
        mob.field_70172_ad = 0;
        if (mob instanceof BatEntity) {
            ((BatEntity)mob).func_82236_f(true);
        }
        if (mob instanceof FoxEntity) {
            ((FoxEntity)mob).func_213485_x(true);
        }
        if (mob instanceof AbstractFishEntity) {
            ((AbstractFishEntity)mob).func_203706_r(true);
        }
        CompoundNBT mobTag = new CompoundNBT();
        mob.func_70039_c(mobTag);
        if (mobTag.isEmpty()) {
            Supplementaries.LOGGER.error("failed to capture mob " + mob + "Something went wrong :/");
            return null;
        }
        mobTag.func_82580_o("Passengers");
        mobTag.func_82580_o("Leash");
        mobTag.func_82580_o("UUID");
        if (mobTag.func_74764_b("FromBucket")) {
            mobTag.func_74757_a("FromBucket", true);
        }
        return mobTag;
    }

    private static <E extends Entity> Pair<Float, Float> calculateMobDimensionsForContainer(E mob, float blockW, float blockH) {
        float yOffset;
        String name;
        float babyScale = 1.0f;
        if (mob instanceof LivingEntity && ((LivingEntity)mob).func_70631_g_()) {
            babyScale = mob instanceof VillagerEntity ? 1.125f : (mob instanceof AgeableEntity ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.func_213311_cf() * babyScale;
        float h = mob.func_213302_cg() * babyScale;
        ICatchableMob cap = MobContainer.getCap(mob);
        cap.getHitBoxHeightIncrement();
        boolean isAir = cap.isFlyingMob();
        float addWidth = cap.getHitBoxWidthIncrement();
        float addHeight = cap.getHitBoxHeightIncrement();
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin) - addHeight;
        float maxW = blockW - 2.0f * margin - addWidth;
        if (w > maxW || h > maxH) {
            scale = w - maxW > h - maxH ? maxW / w : maxH / h;
        }
        if ((name = mob.func_200600_R().getRegistryName().toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale = (float)((double)scale * 0.45);
        }
        float f = yOffset = isAir ? blockH / 2.0f - h * scale / 2.0f : yMargin;
        if (mob instanceof BatEntity) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public static class MobData {
        public final String name;
        public final boolean isAquarium;
        private final ItemStack filledBucket;
        public final CompoundNBT mobTag;
        private final float scale;
        @Nullable
        private final UUID uuid;
        private final int fishIndex;

        public MobData(String name, CompoundNBT mobTag, float scale, UUID id, ItemStack filledBucket) {
            this.isAquarium = false;
            this.name = name;
            this.mobTag = mobTag;
            this.scale = scale;
            this.uuid = id;
            this.filledBucket = filledBucket;
            this.fishIndex = 0;
        }

        public MobData(ItemStack filledBucket) {
            this(CapturedMobsHelper.getDefaultNameFromBucket(filledBucket.func_77973_b()), filledBucket);
        }

        public MobData(String name, ItemStack filledBucket) {
            this(name, CapturedMobsHelper.getTypeFromBucket(filledBucket.func_77973_b()).getFishTexture(), filledBucket);
        }

        public MobData(String name, int fishIndex, ItemStack filledBucket) {
            this.isAquarium = true;
            this.fishIndex = fishIndex;
            this.filledBucket = filledBucket;
            this.name = name;
            this.uuid = null;
            this.scale = 1.0f;
            this.mobTag = null;
        }

        @Nullable
        public static MobData loadFromTag(CompoundNBT tag) {
            if (tag.func_74764_b("MobHolder")) {
                CompoundNBT cmp = tag.func_74775_l("MobHolder");
                CompoundNBT entityData = cmp.func_74775_l("EntityData");
                float scale = cmp.func_74760_g("Scale");
                UUID uuid = cmp.func_74764_b("UUID") ? cmp.func_186857_a("UUID") : null;
                ItemStack bucket = cmp.func_74764_b("Bucket") ? ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("Bucket")) : ItemStack.field_190927_a;
                String name = cmp.func_74779_i("Name");
                if (cmp.func_74764_b("YOffset")) {
                    float y = cmp.func_74760_g("YOffset");
                    ListNBT listnbt = new ListNBT();
                    listnbt.add((Object)DoubleNBT.func_229684_a_((double)0.5));
                    listnbt.add((Object)DoubleNBT.func_229684_a_((double)y));
                    listnbt.add((Object)DoubleNBT.func_229684_a_((double)0.5));
                    if (entityData.func_74764_b("Pos")) {
                        entityData.func_82580_o("Pos");
                    }
                    entityData.func_218657_a("Pos", (INBT)listnbt);
                }
                return new MobData(name, entityData, scale, uuid, bucket);
            }
            if (tag.func_74764_b("BucketHolder")) {
                CompoundNBT cmp = tag.func_74775_l("BucketHolder");
                ItemStack bucket = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("Bucket"));
                if (bucket.func_190926_b()) {
                    bucket = ItemStack.func_199557_a((CompoundNBT)cmp.func_74775_l("BucketHolder"));
                }
                int fish = cmp.func_74762_e("FishTexture");
                String name = cmp.func_74779_i("Name");
                return new MobData(name, fish, bucket);
            }
            return null;
        }

        public void saveToTag(CompoundNBT tag) {
            CompoundNBT cmp = new CompoundNBT();
            cmp.func_74778_a("Name", this.name);
            if (!this.filledBucket.func_190926_b() || this.isAquarium) {
                CompoundNBT bucketTag = new CompoundNBT();
                this.filledBucket.func_77955_b(bucketTag);
                cmp.func_218657_a("Bucket", (INBT)bucketTag);
            }
            if (this.isAquarium) {
                cmp.func_74768_a("FishTexture", this.fishIndex);
                tag.func_218657_a("BucketHolder", (INBT)cmp);
            } else {
                cmp.func_218657_a("EntityData", (INBT)this.mobTag);
                cmp.func_74776_a("Scale", this.scale);
                if (this.uuid != null) {
                    cmp.func_186854_a("UUID", this.uuid);
                }
                tag.func_218657_a("MobHolder", (INBT)cmp);
            }
        }

        public float getScale() {
            return this.scale;
        }

        public int getFishIndex() {
            return this.fishIndex;
        }
    }
}

